<?php
// Endpoint para receber webhook da Alloha.
// Configure a URL no painel deles apontando para: https://SEUDOMINIO/alloha-vendas/webhook.php

require __DIR__ . '/AllohaClient.php';

function loadAllohaConfig(): array {
  // Procura o config.php subindo diretórios (funciona em /public_html/giga/alloha-vendas)
  $candidates = [
    __DIR__ . '/../../alloha_private/config.php',           // /public_html/giga/alloha_private (não recomendado)
    __DIR__ . '/../../../alloha_private/config.php',        // /public_html/alloha_private (não recomendado)
    __DIR__ . '/../../../../alloha_private/config.php',     // /home/USER/alloha_private (recomendado)
    dirname(__DIR__, 2) . '/alloha_private/config.php',
    dirname(__DIR__, 3) . '/alloha_private/config.php',
    dirname(__DIR__, 4) . '/alloha_private/config.php',
  ];
  foreach ($candidates as $p) {
    if (file_exists($p)) return require $p;
  }
  throw new Exception('Config não encontrado. Coloque em /home/SEUUSUARIO/alloha_private/config.php');
}

$cfg = loadAllohaConfig();
$api = new AllohaClient($cfg);

$raw = file_get_contents('php://input');
$api->logWebhook("RAW: " . $raw);

$payload = json_decode($raw, true);
if (!is_array($payload)) {
  http_response_code(400);
  echo "invalid_json";
  exit;
}

// Exemplo esperado: { "transactionId": "...", "integrationStatus": "COMPLETED" }
$tid = $payload['transactionId'] ?? '';
$status = $payload['integrationStatus'] ?? ($payload['status'] ?? '');

$api->logWebhook("transactionId={$tid} status={$status}");

http_response_code(200);
header('Content-Type: text/plain; charset=utf-8');
echo "ok";
