<?php
require __DIR__ . '/AllohaClient.php';

function loadAllohaConfig(): array {
  // Procura o config.php subindo diretórios (funciona em /public_html/giga/alloha-vendas)
  $candidates = [
    __DIR__ . '/../../alloha_private/config.php',           // /public_html/giga/alloha_private (não recomendado)
    __DIR__ . '/../../../alloha_private/config.php',        // /public_html/alloha_private (não recomendado)
    __DIR__ . '/../../../../alloha_private/config.php',     // /home/USER/alloha_private (recomendado)
    dirname(__DIR__, 2) . '/alloha_private/config.php',
    dirname(__DIR__, 3) . '/alloha_private/config.php',
    dirname(__DIR__, 4) . '/alloha_private/config.php',
  ];
  foreach ($candidates as $p) {
    if (file_exists($p)) return require $p;
  }
  throw new Exception('Config não encontrado. Coloque em /home/SEUUSUARIO/alloha_private/config.php');
}

$cfg = loadAllohaConfig();
$apiPrefix = trim($_GET['apiPrefix'] ?? ($_POST['apiPrefix'] ?? ''));
if ($apiPrefix !== '') { $cfg['api_prefix'] = $apiPrefix; }
$api = new AllohaClient($cfg);

$transactionId = trim($_GET['transactionId'] ?? '');
$auto = ($_GET['auto'] ?? '1') === '1';

$css = file_get_contents(__DIR__ . '/style.css');

function page(string $title, string $body, string $css, bool $autoRefresh=false): void {
  header('Content-Type: text/html; charset=utf-8');
  $refresh = $autoRefresh ? "<meta http-equiv='refresh' content='5'>" : "";
  echo "<!doctype html><html lang='pt-br'><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>{$refresh}<title>{$title}</title><style>{$css}</style></head><body>{$body}</body></html>";
  exit;
}

if ($transactionId === '') {
  page('Status', "<h2>Status</h2><div class='card bad'>Informe transactionId na URL.</div><p class='small'><a href='index.php'>Voltar</a></p>", $css);
}

try {
  $token = $api->getAccessToken();
  $status = $api->analysisStatus($token, $transactionId);
  $decision = $status['decision'] ?? 'UNKNOWN';

  $autoRefresh = ($decision === 'PENDING' && $auto);

  $body = "<h2>Status da Análise</h2>";
  $cls = ($decision === 'APPROVED') ? 'ok' : (($decision === 'REJECTED') ? 'bad' : 'warn');
  $body .= "<div class='card {$cls}'><b>Transaction ID:</b> " . htmlspecialchars($transactionId) . "<br><b>Decision:</b> " . htmlspecialchars($decision) . "</div>";

  if ($decision === 'PENDING') {
    $body .= "<div class='card warn'>Aguardando análise... (atualiza a cada 5s)</div>";
  } elseif ($decision === 'APPROVED') {
    $body .= "<div class='card ok'><a href='finalizar.php?transactionId=" . urlencode($transactionId) . "'>👉 Finalizar (agenda)</a></div>";
  } elseif ($decision === 'REJECTED') {
    $body .= "<div class='card bad'>Análise reprovada. Você pode revisar dados e tentar novamente.</div>";
  }

  $toggle = $auto ? "auto=0" : "auto=1";
  $label = $auto ? "Desligar auto refresh" : "Ligar auto refresh";
  $body .= "<p class='small'><a href='status.php?transactionId=" . urlencode($transactionId) . "&{$toggle}'>{$label}</a> | <a href='index.php'>Voltar</a></p>";

  page('Status', $body, $css, $autoRefresh);

} catch (Exception $e) {
  $api->logApp("status.php: " . $e->getMessage());
  $body = "<h2>❌ Erro</h2><div class='card bad'>" . htmlspecialchars($e->getMessage()) . "</div><p class='small'><a href='index.php'>Voltar</a></p>";
  page('Erro', $body, $css);
}
