<?php
// Formulário MVP - Alloha Sale Partner (HML)
?><!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Alloha | Lançar Venda (Teste)</title>
<style>body{font-family:Arial,sans-serif;margin:24px;max-width:980px}
label{display:block;margin-top:12px;font-weight:700}
input,select,button{width:100%;padding:10px;margin-top:6px;box-sizing:border-box}
.row{display:flex;gap:12px}
.row>div{flex:1}
button{cursor:pointer;margin-top:16px}
.card{border:1px solid #ddd;border-radius:10px;padding:14px;margin-top:14px}
.small{color:#666;font-size:13px}
.ok{background:#ecfdf3;border:1px solid #bfeccf}
.bad{background:#fff1f2;border:1px solid #fecdd3}
.warn{background:#fffbeb;border:1px solid #fde68a}
a{color:#0b5fff;text-decoration:none}
a:hover{text-decoration:underline}
code{background:#f4f4f5;padding:2px 6px;border-radius:6px}
</style>
</head>
<body>
<h2>Alloha | Lançar Venda (Teste)</h2>
<div class="card warn">
  <b>Ambiente de teste.</b> Use HTTPS. Não use dados reais se não precisar.
  <div class="small">O sistema vai consultar a viabilidade e puxar o locationId automaticamente. Depois, você acompanha a análise e finaliza com agenda.</div>
</div>

<form method="post" action="submit.php" autocomplete="off">
  <div class="row">
    <div>
      <label>Tipo de Cliente</label>
      <select name="userType" required>
        <option value="NATURAL_PERSON">Pessoa Física</option>
        <option value="LEGAL_PERSON">Pessoa Jurídica</option>
      </select>
    </div></div>
  </div>

  <div class="row">
    <div>
      <label>productId</label>
      <input name="productId" required placeholder="Ex: 999">
    </div>
    <div>
      <label>planUpgradeOptionId (opcional)</label>
      <input name="planUpgradeOptionId" placeholder="Ex: 111">
    </div>
  </div>

  <h3>Endereço</h3>
  <div class="row">
    <div>
      <label>CEP</label>
      <input name="zipCode" required placeholder="Somente números">
    </div>
    <div>
      <label>Número</label>
      <input name="number" required>
    </div>
  </div>
  <label>Rua</label><input name="street" required>
  <label>Bairro</label><input name="neighborhood" required>
  <div class="row">
    <div><label>Cidade</label><input name="city" required></div>
    <div><label>UF</label><input name="state" maxlength="2" required placeholder="PR"></div>
  </div>
  <label>Complemento (opcional)</label><input name="complement">
  <label>Referência (opcional)</label><input name="reference">

  <h3>Cliente</h3>
  <label>Nome completo / Razão social</label><input name="fullName" required>
  <div class="row">
    <div>
      <label>CPF/CNPJ</label>
      <input name="document" required placeholder="Somente números">
    </div>
    <div>
      <label>Data nasc. (opcional)</label>
      <input name="birthDate" placeholder="YYYY-MM-DD">
    </div>
  </div>
  <div class="row">
    <div><label>Telefone</label><input name="phone" required placeholder="Ex: 44999999999"></div>
    <div><label>E-mail</label><input name="email" required type="email"></div>
  </div>

  <button type="submit">Iniciar venda</button>
</form>

<div class="card">
  <b>Próximos passos</b>
  <ol>
    <li>Após iniciar, abra o <code>status.php?transactionId=...</code> para acompanhar.</li>
    <li>Se aprovado, finalize em <code>finalizar.php?transactionId=...</code>.</li>
    <li>Webhook (opcional): configure a URL <code>webhook.php</code> no painel da Alloha.</li>
  </ol>
</div>

</body>
</html>
